#include <stdlib.h>
#include "global.h"
#include "utils.h"
#include "ext_basic.h"
#include "routine.h"
#include "field.h"
#include "evolve.h"

int routine_true(struct S_ROUTINE *r,u64 * parameters,void *data,u64 *result)
{
*result=1;
return 0;
}

int routine_false(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
*result=0;
return 0;
}

int routine_duplicate(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
*result=0;
return -1;
}

int routine_coin(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
*result=make_random_bool();
return 0;
}

int routine_rand(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
*result=make_random_int(0,999);
return 0;
}

int routine_agent_x(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
FIELD *f;
f=get_current_field();
if(f==NULL)return -1;
*result=X(f->current);
return 0;
}

int routine_agent_y(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
FIELD *f;
f=get_current_field();
if(f==NULL)return -1;
*result=Y(f->current);
return 0;
}

int routine_agentclass(struct S_ROUTINE *r,u64 *parameters,void *data,u64 *result)
{
AGENT *a;
a=get_current_agent();
if(a==NULL)return -1;
*result=a->class_handle;
return 0;
}

int routine_attribute(struct S_ROUTINE *r, u64 *parameters,void *data,u64 *result)
{
AGENT *a;
a=get_current_agent();
if(a==NULL)return -1;
return get_attribute_value(a,parameters[0],result);
}

int routine_activated(struct S_ROUTINE *r, u64 *parameters,void *data,u64 *result)
{
AGENT *a;
int err;
a=get_current_agent();
if(a==NULL)return -1;
err=get_attribute_value(a,parameters[0],result);
*result=(*result)>>56;
return err;
}

int routine_top_rank_square(struct S_ROUTINE *r, u64 *parameters,void *data,u64 *result)
{
FIELD *f;
long radius;
long range;
long attribute;
long *dataf;
long i,j;
AGENT *a;
*result=0;
if(parameters==NULL)return -1;
radius=parameters[0];
range=parameters[1];
attribute=parameters[2];
dataf=do_alloc(range,sizeof(u64));
f=get_current_field();
for(i=0;i<range;i++)dataf[i]=0;
for(i=-radius;i<=radius;i++)
	for(j=-radius;j<=radius;j++){
		a=get_agent(f,LOC(i,j));
		if(a!=NULL){
			dataf[a->attribute[attribute] % range]++;			
			}
		}
for(i=1;i<range;i++)
	if(dataf[*result]<dataf[i])*result=i;
free(dataf);		
return 0;
}

int routine_tension_square(struct S_ROUTINE *r, u64 *parameters,void *data,u64 *result)
{
FIELD *f;
long radius;
long r_ind;
u64 val1,val2;
long i,j;
LOCATION cur1;
long x,y;
*result=0;
if(parameters==NULL)return -1;
radius=parameters[0];
r_ind=parameters[1];
f=get_current_field();
if(f==NULL)return -1;
cur1=f->current;
x=X(cur1);
y=Y(cur1);
if(evaluate_routine(r_ind,&val1)<0)return -1;
for(i=-radius;i<=radius;i++)
	for(j=-radius;j<=radius;j++){
		if((!i)||(!j)){
			set_current_agent(i+x,j+y);
			if(evaluate_routine(r_ind,&val2)<0){
				f->current=cur1;
				return -1;
				}
			if(val1!=val2)(*result)++;
			}
		}
f->current=cur1;
return 0;
}

/* parameters :
      attribute (attribute index)
      range  (integer function)
      applicable  (boolean function)
      level1     (integer function)
      level2    (integer function)
      level3    (integer function)
*/      
int routine_evolve_repertoire(struct S_ROUTINE *r, u64 *parameters,void *data,u64 *result)
{
ATTRIBUTE *a;
AGENT *a1;
REPERTOIRE_VALUES *r_v;
u64 range,a2,level1,level2,level3;
int i,j,b,c;
FIELD *f;
LOCATION cur;
if(parameters==NULL)return -1;
f=get_current_field();
if(f==NULL)return -1;
cur=f->current;
a=get_attribute(parameters[0]);
r_v=&(a->param.rep);
for(i=0;i<r_v->size;i++)r_v->data1[i]=0;
if(evaluate_routine(parameters[1],&range))return -1;
for(i=-range;i<=range;i++)
	for(j=-range;j<=range;j++){
		a1=get_agent(f,LOC(i,j));
		/* next stuff should be adjusted */
		if(a1!=NULL){
			set_current_agent(X(cur)+i,Y(cur)+j);
			if((evaluate_routine(parameters[2],&a2)>=0)&&(a2)){
				b=ACTIVATED(a1->attribute[parameters[0]]);
				if(R_SET(a1->attribute[parameters[0]])& (((u64)1)<<b))
					r_v->data1[b]++;
				}
			set_current_agent(X(cur),Y(cur));			
			}
		}
b=0; /* top */

a1=get_agent(f,LOC(0,0));
a2=R_SET(a1->attribute[parameters[0]]);
for(c=0;(c<r_v->size)&&(!(a2 & (((u64)1)<<c)));c++);

for(i=1;i<r_v->size;i++){
	if(r_v->data1[b]<r_v->data1[i])b=i;
	if((r_v->data1[c]>r_v->data1[i])&&(a2 & (((u64)1)<<i)))c=i;
	}

if(evaluate_routine(parameters[3],&level1)<0)return -1;
if(level1<r_v->data1[b]){
	if(a2 & (((u64)1)<<b)) {
		*result=REPERTOIRE(b,a2);
		return 0;
		} else {
		*result=REPERTOIRE(b,(a2 | (((u64)1)<<b) )& (~((((u64)1)<<c))));
		return 0;
		}
	}
if(evaluate_routine(parameters[4],&level2)<0)return -1;
if(level2<r_v->data1[b]){
	if(a2 & (((u64)1)<<b)){
		*result=REPERTOIRE(b,a2);
		return 0;
		}
	}
if(evaluate_routine(parameters[5],&level3)<0)return -1;
if(level3<r_v->data1[b]){
	/* ... */
	}
*result=a1->attribute[parameters[0]]; /* unchanged */
return 0;
}

u64 param_x1[1]={TYPE_ATTR};
u64 param_x2[3]={TYPE_INT,TYPE_INT,TYPE_ATTR};
u64 param_x3[2]={TYPE_INT,TYPE_FUNC};
u64 param_x4[6]={TYPE_ATTR,TYPE_FUNC,TYPE_FUNC,TYPE_FUNC,TYPE_FUNC,TYPE_FUNC};

ROUTINE ext_basic_routines[]={
	{ROUTINE_BUILTIN|VALID_RESULT,"true","Always returns true",TYPE_BOOL,0,NULL,routine_true,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"false","Always returns false",TYPE_BOOL,0,NULL,routine_false,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"duplicate","Always returns error (signal to preserve old value of an attribute)",TYPE_BOOL,0,NULL,routine_duplicate,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"error","Always returns error",TYPE_BOOL,0,NULL,routine_duplicate,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"coin","Returns true or false with equal probability",TYPE_INT,0,NULL,routine_coin,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"rand","Returns random integer between 0 and 999",TYPE_INT,0,NULL,routine_rand,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"agent_x","Returns X coordinate of the current agent",TYPE_INT,0,NULL,routine_agent_x,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"agent_y","Returns Y coordinate of the current agent",TYPE_INT,0,NULL,routine_agent_y,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"agentclass","Returns the agentclass number of the current agent",TYPE_INT,0,NULL,routine_agentclass,NULL},
	{ROUTINE_BUILTIN|VALID_RESULT,"time","Returns the number of the evolution step",TYPE_INT,0,NULL,(ROUTINE_CODE)get_time,NULL},
	{ROUTINE_BUILTIN|ROUTINE_CUSTOMIZED|VALID_RESULT,"attribute_value","Returns the value of a specific attribute",TYPE_INT,1,
   		 param_x1,(ROUTINE_CODE)routine_attribute,NULL},
	{ROUTINE_BUILTIN|ROUTINE_CUSTOMIZED|VALID_RESULT,"activated","Returns the number of activated identity (only makes sense for repertoire type attributes)",TYPE_INT,1,
   	    param_x1,
			(ROUTINE_CODE)routine_activated,NULL},
	{ROUTINE_BUILTIN|ROUTINE_CUSTOMIZED|VALID_RESULT,"top_rank_square",
		"Returns the value of a specific attribute that occurs most often in a square of specified size",
		TYPE_INT,3,param_x2,(ROUTINE_CODE)routine_top_rank_square,NULL},
	{ROUTINE_BUILTIN|ROUTINE_CUSTOMIZED|VALID_RESULT,"tension_square",
		"Returns the number of agents with different value of a specific attribute in a square of specified size",
		TYPE_INT,2,param_x3,(ROUTINE_CODE)routine_tension_square,NULL},
	{ROUTINE_BUILTIN|ROUTINE_CUSTOMIZED|VALID_RESULT,"evolve_repertoire",
		"Is a prototype for constructing evolution routines for repertoire attributes",
		TYPE_INT,6,param_x4,(ROUTINE_CODE)routine_evolve_repertoire,NULL},
	{0,NULL,NULL,0,NULL,NULL,NULL}
	};


void init_ext_basic(void)
{
long i;
for(i=0;ext_basic_routines[i].type;i++)
	add_routine(ext_basic_routines[i].name,ext_basic_routines[i].comment,
		ext_basic_routines[i].type,ext_basic_routines[i].result,
		ext_basic_routines[i].param_count,ext_basic_routines[i].param_type,
		ext_basic_routines[i].execute,ext_basic_routines[i].data);

}

